﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using RevisionAnalyser.Controls;

namespace RevisionAnalyser.Projects
{
    public abstract class Project
    {
        public abstract void FirstRun();
        public abstract void Opened();
        public abstract void InitMenu(ToolStripMenuItem menu);

        protected delegate void OpenSolidSXFileDelegate(Form taskForm, string path);

        private string _projectFolder = string.Empty;
        public string ProjectFolder
        {
            get
            {
                return _projectFolder;
            }
            set
            {
                _projectFolder = value;
            }
        }

        private string _projectFile = string.Empty;
        public string ProjectFile
        {
            get
            {
                return _projectFile;
            }
            set
            {
                _projectFile = value;
            }
        }

        private XmlDocument _xmlDoc = new XmlDocument();
        public XmlDocument XmlDoc
        {
            get
            {
                return _xmlDoc;
            }
        }

        private RevisionSet _revisionSet;
        public RevisionSet RevisionSet
        {
            get
            {
                return _revisionSet;
            }
            set
            {
                _revisionSet = value;
            }
        }

        private MainForm _mainForm;
        public MainForm MainForm
        {
            get
            {
                return _mainForm;
            }
            set
            {
                _mainForm = value;
            }
        }

        public void SaveXml()
        {
            if (ProjectFile != string.Empty)
            {
                XmlDoc.Save(ProjectFile);
            }
        }

        /*
        public void OpenSolidSXFile(Form taskForm, string path)
        {
            if (SolidSX.InvokeRequired)
            {
                taskForm.BeginInvoke(new OpenSolidSXFileDelegate(OpenSolidSXFile), new object[] { taskForm, path });
            }
            else
            {
                SolidSX.OpenSolidSX(path);
                SolidSX.SetNodeColorAttribute("<none>");
                SolidSX.SetNodeColormap("Rainbow");
            }
        }
         */

    }
}
